package com.example.sms_call_sync;

import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;

import java.util.ArrayList;
import java.util.Set;

public class SettingsActivity extends AppCompatActivity {

    private EditText etBlockedNumber;
    private Button btnAddBlockedNumber;
    private ListView lvBlockedNumbers;
    private ArrayAdapter<String> blockedNumbersAdapter;
    private ArrayList<String> blockedNumbersList;
    private SyncManager syncManager; // Use SyncManager to interact with blocked numbers

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_settings);

        initViews();
        syncManager = new SyncManager(this); // Initialize SyncManager

        loadBlockedNumbers();
        setupListeners();
    }

    private void initViews() {
        etBlockedNumber = findViewById(R.id.et_blocked_number);
        btnAddBlockedNumber = findViewById(R.id.btn_add_blocked_number);
        lvBlockedNumbers = findViewById(R.id.lv_blocked_numbers);
    }

    private void loadBlockedNumbers() {
        // Access dbHelper via the public getter method
        Set<String> blockedSet = syncManager.getDbHelper().getBlockedNumbers(); 
        blockedNumbersList = new ArrayList<>(blockedSet);
        blockedNumbersAdapter = new ArrayAdapter<>(this,
                android.R.layout.simple_list_item_1,
                blockedNumbersList);
        lvBlockedNumbers.setAdapter(blockedNumbersAdapter);
    }

    private void setupListeners() {
        btnAddBlockedNumber.setOnClickListener(v -> addBlockedNumber());

        lvBlockedNumbers.setOnItemClickListener((parent, view, position, id) -> {
            final String numberToRemove = blockedNumbersList.get(position);
            
            // Use SyncManager's method to remove blocked number
            syncManager.removeBlockedNumber(numberToRemove); 
            blockedNumbersList.remove(position);
            blockedNumbersAdapter.notifyDataSetChanged();
            Toast.makeText(SettingsActivity.this, "Removed: " + numberToRemove, Toast.LENGTH_SHORT).show();
        });
    }

    private void addBlockedNumber() {
        String number = etBlockedNumber.getText().toString().trim();
        if (number.isEmpty()) {
            Toast.makeText(this, "Please enter a number to block", Toast.LENGTH_SHORT).show();
            return;
        }

        if (blockedNumbersList.contains(number)) {
            Toast.makeText(this, "Number already blocked", Toast.LENGTH_SHORT).show();
            return;
        }

        // Use SyncManager's method to add blocked number
        syncManager.addBlockedNumber(number); 
        blockedNumbersList.add(number);
        blockedNumbersAdapter.notifyDataSetChanged();
        etBlockedNumber.setText("");
        Toast.makeText(this, "Number blocked: " + number, Toast.LENGTH_SHORT).show();
    }
}
