/*
 * Decompiled with CFR 0.152.
 */
package com.example.sms_call_sync;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.preference.PreferenceManager;
import android.util.Log;
import java.util.HashSet;
import java.util.Set;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private static final String DATABASE_NAME = "app_data.db";
    private static final int DATABASE_VERSION = 1;
    private static final String TABLE_BLOCKED_NUMBERS = "blocked_numbers";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_NUMBER = "number";
    private Context context;

    public DatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 1);
        this.context = context;
    }

    public void onCreate(SQLiteDatabase db) {
        String CREATE_BLOCKED_NUMBERS_TABLE = "CREATE TABLE blocked_numbers(id INTEGER PRIMARY KEY AUTOINCREMENT,number TEXT UNIQUE)";
        db.execSQL(CREATE_BLOCKED_NUMBERS_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS blocked_numbers");
        this.onCreate(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockedNumber(String number) {
        SQLiteDatabase db = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put(COLUMN_NUMBER, number);
        try {
            db.insert(TABLE_BLOCKED_NUMBERS, null, values);
            Log.d((String)"DatabaseHelper", (String)("Blocked number added: " + number));
        }
        catch (Exception e) {
            Log.e((String)"DatabaseHelper", (String)("Error adding blocked number: " + e.getMessage()));
        }
        finally {
            db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlockedNumber(String number) {
        try (SQLiteDatabase db = this.getWritableDatabase();){
            db.delete(TABLE_BLOCKED_NUMBERS, "number = ?", new String[]{number});
            Log.d((String)"DatabaseHelper", (String)("Blocked number removed: " + number));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getBlockedNumbers() {
        HashSet<String> blockedNumbers = new HashSet<String>();
        String selectQuery = "SELECT * FROM blocked_numbers";
        SQLiteDatabase db = this.getReadableDatabase();
        Cursor cursor = null;
        try {
            cursor = db.rawQuery(selectQuery, null);
            if (cursor.moveToFirst()) {
                int numberColumnIndex = cursor.getColumnIndex(COLUMN_NUMBER);
                if (numberColumnIndex != -1) {
                    do {
                        blockedNumbers.add(cursor.getString(numberColumnIndex));
                    } while (cursor.moveToNext());
                } else {
                    Log.e((String)"DatabaseHelper", (String)"Column 'number' not found in blocked_numbers table.");
                }
            }
        }
        catch (Exception e) {
            Log.e((String)"DatabaseHelper", (String)("Error getting blocked numbers: " + e.getMessage()));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            db.close();
        }
        return blockedNumbers;
    }

    public String getPhoneName() {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        return sharedPreferences.getString("phone_name", "");
    }
}

