<?php
ini_set('memory_limit', '256M');
ini_set('display_errors', 0); // Disable display of errors
ini_set('log_errors', 1); // Enable error logging
error_reporting(E_ALL); // Report all errors but don't display them
$dbHost = 'localhost';
$dbUser = 'bdinfcom_SMS';
$dbPass = '!8OGQ!K+V!==';
$dbName = 'bdinfcom_SMS';
$conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
if ($conn->connect_error) {
    die("DB Connection failed: " . $conn->connect_error);
}

// Check if blocked_numbers_global table exists
$blockedTableExists = false;
$res = $conn->query("SHOW TABLES LIKE 'blocked_numbers_global'");
if ($res && $res->num_rows > 0) {
    $blockedTableExists = true;
}

// Handle adding a new blocked number
$successMessage = '';
$errorMessage = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_blocked_number'])) {
    $phoneName = $conn->real_escape_string($_POST['phone_name']);
    $blockedNumber = $conn->real_escape_string($_POST['blocked_number']);
    
    if (!empty($blockedNumber)) {
        try {
            // Check if the number already exists
            $checkSql = "SELECT id FROM blocked_numbers_global WHERE blocked_number = '$blockedNumber'";
            $checkResult = $conn->query($checkSql);
            
            if ($checkResult && $checkResult->num_rows > 0) {
                $errorMessage = "This number is already in the blocked list!";
            } else {
                $insertSql = "INSERT INTO blocked_numbers_global (phone_name, blocked_number, created_at) VALUES ('$phoneName', '$blockedNumber', NOW())";
                if ($conn->query($insertSql)) {
                    $successMessage = "Blocked number added successfully!";
                } else {
                    $errorMessage = "Error adding blocked number.";
                }
            }
        } catch (Exception $e) {
            $errorMessage = "Error adding blocked number.";
        }
    } else {
        $errorMessage = "Blocked number is required!";
    }
}

// Handle deleting a blocked number
if (isset($_GET['delete_blocked']) && is_numeric($_GET['delete_blocked'])) {
    $id = (int)$_GET['delete_blocked'];
    try {
        $deleteSql = "DELETE FROM blocked_numbers_global WHERE id = $id";
        if ($conn->query($deleteSql)) {
            $successMessage = "Blocked number deleted successfully!";
        } else {
            $errorMessage = "Error deleting blocked number.";
        }
    } catch (Exception $e) {
        $errorMessage = "Error deleting blocked number.";
    }
}

// Get current blocked numbers
$blockedNumbers = [];
if ($blockedTableExists) {
    try {
        $result = $conn->query("SELECT * FROM blocked_numbers_global ORDER BY created_at DESC");
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $blockedNumbers[] = $row;
            }
        }
    } catch (Exception $e) {
        // Silently handle error
    }
}

// Pagination settings
$itemsPerPage = 20; // Number of items per page
$currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1; // Current page
$offset = ($currentPage - 1) * $itemsPerPage; // Calculate offset

// Get all sms tables
$tables = [];
try {
    $res = $conn->query("SHOW TABLES LIKE '%_sms'");
    if ($res) {
        while ($row = $res->fetch_row()) {
            $tables[] = $row[0];
        }
    }
} catch (Exception $e) {
    // Silently handle error
}

$selectedTable = $_GET['table'] ?? '';
if ($selectedTable && !in_array($selectedTable, $tables)) {
    die("Invalid table selected.");
}

// Filter inputs
$filters = [
    'from_date' => $_GET['from_date'] ?? '',
    'to_date' => $_GET['to_date'] ?? '',
    'ac' => $_GET['ac'] ?? '',
    'amount' => $_GET['amount'] ?? '',
    'debit' => $_GET['debit'] ?? '',
    'credit' => $_GET['credit'] ?? '',
    'balance' => $_GET['balance'] ?? '',
    'sender' => $_GET['sender'] ?? '',
    'transaction_id' => $_GET['transaction_id'] ?? '',
    'cheque_no' => $_GET['cheque_no'] ?? ''
];

// Convert dates (Y-m-d) to timestamps in milliseconds for query filtering
$fromTimestamp = null;
$toTimestamp = null;
if ($filters['from_date']) {
    $fromTimestamp = strtotime($filters['from_date'] . ' 00:00:00') * 1000;
}
if ($filters['to_date']) {
    $toTimestamp = strtotime($filters['to_date'] . ' 23:59:59') * 1000;
}

function parse_sms_body($body) {
    $result = [
        'A/C' => '',
        'Amount' => '',
        'Debit' => '',
        'Credit' => '',
        'Balance' => '',
        'Sender' => '',
        'Transaction ID' => '',
        'Cheque No' => '',
    ];
    $text = preg_replace("/[\r\n]+/", " ", $body);
    $text = preg_replace('/\s+/', ' ', $text);
    
    // Enhanced pattern for A/C to capture formats like "A/C # 029-08235-60-8035"
    if (preg_match('/(?:A\/C|Account|Acc|A\/C#|A\/C:|Acc:|Investment A\/C)[\s\-:#]*([0-9*\-]{5,20})/i', $text, $m)) {
        $result['A/C'] = $m[1];
    }
    
    // Enhanced pattern for Amount to capture formats like "Tk. 1,000" and "Tk. 38,000"
    if (preg_match('/(?:BDT|Tk|৳|TK\.?)\s*([\d,]+(?:\.\d{2})?)/i', $text, $m)) {
        $result['Amount'] = str_replace(',', '', $m[1]);
    }
    
    // Enhanced pattern for Debit to capture amounts without decimals
    if (preg_match('/(?:withdrawn|debited|sent|paid|withdrawal|withdraw)[^0-9]*([\d,]+(?:\.\d{2})?)/i', $text, $m)) {
        $result['Debit'] = str_replace(',', '', $m[1]);
        if (empty($result['Amount'])) $result['Amount'] = $result['Debit'];
    }
    
    // Enhanced pattern for Credit to capture formats like "Credited by Tk. 1,000" and "Payment of Tk. 38,000 has been received"
    if (preg_match('/(?:deposited|credited|received|recharged|Payment of)[^0-9]*([\d,]+(?:\.\d{2})?)/i', $text, $m)) {
        $result['Credit'] = str_replace(',', '', $m[1]);
        if (empty($result['Amount'])) $result['Amount'] = $result['Credit'];
    }
    
    // Enhanced pattern for Balance to capture amounts without decimals
    if (preg_match('/(?:bal|balance|avl bal|available balance)[\s:]*[A-Za-z]*\s*([\d,]+(?:\.\d{2})?)/i', $text, $m)) {
        $result['Balance'] = str_replace(',', '', $m[1]);
    }
    
    // Pattern for Transaction ID
    if (preg_match('/(?:trxid|transaction id|txn id|ref no|ref|reference|trx id)[\s:]*([A-Z0-9]{5,})/i', $text, $m)) {
        $result['Transaction ID'] = $m[1];
    }
    
    // Pattern for Cheque No
    if (preg_match('/(?:cheque no|chq no|cheque|chq)[\s:]*([A-Z0-9]{3,})/i', $text, $m)) {
        $result['Cheque No'] = $m[1];
    }
    
    return $result;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMS Transaction Viewer</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary-color: #4a6bdf;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --warning-color: #ffc107;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
            --border-color: #dee2e6;
            --shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            --shadow-lg: 0 1rem 3rem rgba(0, 0, 0, 0.175);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f7fb;
            color: #333;
            line-height: 1.6;
            padding: 20px;
        }

        .container {
            max-width: 1400px;
            margin: 0 auto;
            background-color: white;
            border-radius: 10px;
            box-shadow: var(--shadow-lg);
            padding: 25px;
            margin-bottom: 30px;
        }

        h1, h2, h3 {
            color: var(--dark-color);
            margin-bottom: 20px;
        }

        h1 {
            text-align: center;
            font-size: 2rem;
            padding-bottom: 15px;
            border-bottom: 2px solid var(--primary-color);
            margin-bottom: 30px;
        }

        .tabs {
            display: flex;
            margin-bottom: 20px;
            border-bottom: 1px solid var(--border-color);
        }

        .tab {
            padding: 12px 20px;
            cursor: pointer;
            border-bottom: 3px solid transparent;
            margin-right: 5px;
            font-weight: 600;
            color: var(--secondary-color);
            transition: all 0.3s;
        }

        .tab.active {
            color: var(--primary-color);
            border-bottom-color: var(--primary-color);
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }

        .blocked-numbers-section {
            background-color: var(--light-color);
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
        }

        .blocked-numbers-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .blocked-numbers-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: var(--primary-color);
        }

        .add-blocked-form {
            display: grid;
            grid-template-columns: 1fr 2fr auto;
            gap: 15px;
            margin-bottom: 20px;
            align-items: end;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-group label {
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--dark-color);
            font-size: 0.9rem;
        }

        .form-group input {
            padding: 12px;
            border: 1px solid var(--border-color);
            border-radius: 5px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .form-group input:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 0.2rem rgba(74, 107, 223, 0.25);
        }

        .blocked-numbers-list {
            margin-top: 20px;
        }

        .blocked-number-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px;
            border: 1px solid var(--border-color);
            border-radius: 5px;
            margin-bottom: 10px;
            background-color: white;
        }

        .blocked-number-info {
            display: flex;
            align-items: center;
        }

        .blocked-number-icon {
            background-color: var(--danger-color);
            color: white;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
        }

        .blocked-number-details h4 {
            margin-bottom: 5px;
            color: var(--dark-color);
        }

        .blocked-number-details p {
            margin: 0;
            color: var(--secondary-color);
            font-size: 0.9rem;
        }

        .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 5px;
            font-size: 0.9rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }

        .btn-danger {
            background-color: var(--danger-color);
            color: white;
        }

        .btn-danger:hover {
            background-color: #c82333;
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }

        .btn-primary {
            background-color: var(--primary-color);
            color: white;
        }

        .btn-primary:hover {
            background-color: #3a5bd9;
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }

        .filter-section {
            background-color: var(--light-color);
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 25px;
            box-shadow: var(--shadow);
        }

        .filter-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }

        .filter-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: var(--primary-color);
        }

        .filter-toggle {
            display: none;
            background: none;
            border: none;
            color: var(--primary-color);
            font-size: 1.2rem;
            cursor: pointer;
        }

        .filter-container {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }

        .filter-group {
            display: flex;
            flex-direction: column;
        }

        .filter-group label {
            font-weight: 600;
            margin-bottom: 8px;
            color: var(--dark-color);
            font-size: 0.9rem;
        }

        .filter-group input, .filter-group select {
            padding: 12px;
            border: 1px solid var(--border-color);
            border-radius: 5px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        .filter-group input:focus, .filter-group select:focus {
            border-color: var(--primary-color);
            outline: none;
            box-shadow: 0 0 0 0.2rem rgba(74, 107, 223, 0.25);
        }

        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }

        .btn-secondary {
            background-color: var(--secondary-color);
            color: white;
        }

        .btn-secondary:hover {
            background-color: #5a6268;
            transform: translateY(-2px);
            box-shadow: var(--shadow);
        }

        .table-container {
            overflow-x: auto;
            border-radius: 8px;
            box-shadow: var(--shadow);
            margin-bottom: 25px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background-color: white;
        }

        th, td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid var(--border-color);
        }

        th {
            background-color: var(--primary-color);
            color: white;
            font-weight: 600;
            position: sticky;
            top: 0;
            z-index: 10;
        }

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        tr:hover {
            background-color: #f1f5ff;
        }

        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 25px 0;
            flex-wrap: wrap;
            gap: 10px;
        }

        .pagination a, .pagination span {
            padding: 10px 15px;
            text-decoration: none;
            border: 1px solid var(--border-color);
            border-radius: 5px;
            color: var(--dark-color);
            transition: all 0.3s;
        }

        .pagination a:hover {
            background-color: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
        }

        .pagination .current-page {
            background-color: var(--primary-color);
            color: white;
            border-color: var(--primary-color);
            font-weight: 600;
        }

        .pagination-info {
            text-align: center;
            color: var(--secondary-color);
            margin-top: 15px;
            font-size: 0.9rem;
        }

        .no-data {
            text-align: center;
            padding: 40px;
            color: var(--secondary-color);
            font-size: 1.1rem;
        }

        .no-data i {
            font-size: 3rem;
            margin-bottom: 15px;
            color: var(--border-color);
        }

        .info-banner {
            background-color: #e7f3ff;
            border-left: 4px solid var(--primary-color);
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 0 5px 5px 0;
        }

        .info-banner i {
            color: var(--primary-color);
            margin-right: 10px;
        }

        /* Modal styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            animation: fadeIn 0.3s;
        }

        .modal-content {
            background-color: white;
            margin: 15% auto;
            padding: 20px;
            border-radius: 8px;
            width: 80%;
            max-width: 500px;
            box-shadow: var(--shadow-lg);
            animation: slideIn 0.3s;
            text-align: center;
        }

        .modal-header {
            margin-bottom: 15px;
        }

        .modal-header h3 {
            margin: 0;
            color: var(--dark-color);
        }

        .modal-body {
            margin-bottom: 20px;
        }

        .modal-footer {
            display: flex;
            justify-content: center;
        }

        .modal-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }

        .modal-btn-primary {
            background-color: var(--primary-color);
            color: white;
        }

        .modal-btn-primary:hover {
            background-color: #3a5bd9;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        @keyframes slideIn {
            from { transform: translateY(-50px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }

        /* Responsive adjustments */
        @media (max-width: 992px) {
            .filter-container {
                grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            }
            
            .add-blocked-form {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .filter-header {
                justify-content: center;
            }
            
            .filter-toggle {
                display: block;
            }
            
            .filter-container {
                display: none;
            }
            
            .filter-container.active {
                display: grid;
            }
            
            .table-container {
                font-size: 0.9rem;
            }
            
            th, td {
                padding: 10px 8px;
            }
            
            .blocked-number-item {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .blocked-number-info {
                margin-bottom: 10px;
            }
        }

        @media (max-width: 576px) {
            .container {
                padding: 15px;
            }
            
            h1 {
                font-size: 1.5rem;
            }
            
            .filter-container {
                grid-template-columns: 1fr;
            }
            
            .action-buttons {
                flex-direction: column;
                width: 100%;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
            
            .pagination a, .pagination span {
                padding: 8px 12px;
                font-size: 0.9rem;
            }
            
            .modal-content {
                width: 95%;
                margin: 20% auto;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1><i class="fas fa-sms"></i> SMS Transaction Viewer</h1>
        
        <!-- Modal for messages -->
        <div id="messageModal" class="modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 id="modalTitle">Notification</h3>
                </div>
                <div class="modal-body">
                    <p id="modalMessage"></p>
                </div>
                <div class="modal-footer">
                    <button class="modal-btn modal-btn-primary" onclick="closeModal()">OK</button>
                </div>
            </div>
        </div>
        
        <!-- Tabs -->
        <div class="tabs">
            <div class="tab active" id="transactions-tab">
                <i class="fas fa-exchange-alt"></i> Transactions
            </div>
            <div class="tab" id="blocked-numbers-tab">
                <i class="fas fa-ban"></i> Blocked Numbers
            </div>
        </div>
        
        <!-- Transactions Tab Content -->
        <div class="tab-content active" id="transactions-content">
            <?php if ($blockedTableExists): ?>
            <div class="info-banner">
                <i class="fas fa-info-circle"></i>
                <span>Messages from blocked numbers are automatically filtered out.</span>
            </div>
            <?php endif; ?>
            
            <div class="filter-section">
                <div class="filter-header">
                    <div class="filter-title"><i class="fas fa-filter"></i> Search & Filter</div>
                    <button class="filter-toggle" id="filterToggle"><i class="fas fa-chevron-down"></i></button>
                </div>
                
                <form method="get" id="filterForm">
                    <div class="filter-container" id="filterContainer">
                        <div class="filter-group">
                            <label for="table">Table</label>
                            <select id="table" name="table" required>
                                <option value="">-- Select Table --</option>
                                <?php foreach ($tables as $table): ?>
                                    <option value="<?=htmlspecialchars($table)?>" <?= ($table === $selectedTable) ? 'selected' : '' ?>>
                                        <?=htmlspecialchars(str_replace('_sms', '', $table))?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div class="filter-group">
                            <label for="from_date">From Date</label>
                            <input type="date" id="from_date" name="from_date" value="<?=htmlspecialchars($filters['from_date'])?>">
                        </div>
                        
                        <div class="filter-group">
                            <label for="to_date">To Date</label>
                            <input type="date" id="to_date" name="to_date" value="<?=htmlspecialchars($filters['to_date'])?>">
                        </div>
                        
                        <div class="filter-group">
                            <label for="ac">A/C</label>
                            <input type="text" id="ac" name="ac" value="<?=htmlspecialchars($filters['ac'])?>" placeholder="Account number">
                        </div>
                        
                        <div class="filter-group">
                            <label for="amount">Amount</label>
                            <input type="text" id="amount" name="amount" value="<?=htmlspecialchars($filters['amount'])?>" placeholder="Transaction amount">
                        </div>
                        
                        <div class="filter-group">
                            <label for="debit">Debit</label>
                            <input type="text" id="debit" name="debit" value="<?=htmlspecialchars($filters['debit'])?>" placeholder="Debit amount">
                        </div>
                        
                        <div class="filter-group">
                            <label for="credit">Credit</label>
                            <input type="text" id="credit" name="credit" value="<?=htmlspecialchars($filters['credit'])?>" placeholder="Credit amount">
                        </div>
                        
                        <div class="filter-group">
                            <label for="balance">Balance</label>
                            <input type="text" id="balance" name="balance" value="<?=htmlspecialchars($filters['balance'])?>" placeholder="Account balance">
                        </div>
                        
                        <div class="filter-group">
                            <label for="sender">Sender</label>
                            <input type="text" id="sender" name="sender" value="<?=htmlspecialchars($filters['sender'])?>" placeholder="Sender name/number">
                        </div>
                        
                        <div class="filter-group">
                            <label for="transaction_id">Transaction ID</label>
                            <input type="text" id="transaction_id" name="transaction_id" value="<?=htmlspecialchars($filters['transaction_id'])?>" placeholder="Transaction ID">
                        </div>
                        
                        <div class="filter-group">
                            <label for="cheque_no">Cheque No</label>
                            <input type="text" id="cheque_no" name="cheque_no" value="<?=htmlspecialchars($filters['cheque_no'])?>" placeholder="Cheque number">
                        </div>
                    </div>
                    
                    <div class="action-buttons">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search"></i> Apply Filters
                        </button>
                        <button type="button" class="btn btn-secondary" id="resetBtn">
                            <i class="fas fa-redo"></i> Reset Filters
                        </button>
                    </div>
                </form>
            </div>
            
            <?php if ($selectedTable): ?>
            <h3><i class="fas fa-table"></i> SMS Data from: <?=htmlspecialchars(str_replace('_sms', '', $selectedTable))?></h3>
            <?php
            // Build query with filtering conditions
            $sql = "SELECT * FROM `$selectedTable`";
            $conditions = [];

            // Date filtering
            if ($fromTimestamp !== null) {
                $conditions[] = "`date` >= $fromTimestamp";
            }
            if ($toTimestamp !== null) {
                $conditions[] = "`date` <= $toTimestamp";
            }

            // Text filtering
            if (!empty($filters['sender'])) {
                $sender = $conn->real_escape_string($filters['sender']);
                $conditions[] = "`address` LIKE '%$sender%'";
            }

            // For other fields, we need to search in the body
            if (!empty($filters['ac'])) {
                $ac = $conn->real_escape_string($filters['ac']);
                $conditions[] = "`body` LIKE '%$ac%'";
            }

            if (!empty($filters['amount'])) {
                $amount = $conn->real_escape_string($filters['amount']);
                $conditions[] = "`body` LIKE '%$amount%'";
            }

            if (!empty($filters['debit'])) {
                $debit = $conn->real_escape_string($filters['debit']);
                $conditions[] = "`body` LIKE '%$debit%'";
            }

            if (!empty($filters['credit'])) {
                $credit = $conn->real_escape_string($filters['credit']);
                $conditions[] = "`body` LIKE '%$credit%'";
            }

            if (!empty($filters['balance'])) {
                $balance = $conn->real_escape_string($filters['balance']);
                $conditions[] = "`body` LIKE '%$balance%'";
            }

            if (!empty($filters['transaction_id'])) {
                $transaction_id = $conn->real_escape_string($filters['transaction_id']);
                $conditions[] = "`body` LIKE '%$transaction_id%'";
            }

            if (!empty($filters['cheque_no'])) {
                $cheque_no = $conn->real_escape_string($filters['cheque_no']);
                $conditions[] = "`body` LIKE '%$cheque_no%'";
            }

            // Add blocked numbers filter if table exists
            if ($blockedTableExists) {
                $conditions[] = "`address` NOT IN (SELECT blocked_number FROM blocked_numbers_global)";
            }

            // Add conditions to query
            if ($conditions) {
                $sql .= " WHERE " . implode(' AND ', $conditions);
            }

            // Get total records count for pagination
            $countSql = "SELECT COUNT(*) as total FROM `$selectedTable`";
            if ($conditions) {
                $countSql .= " WHERE " . implode(' AND ', $conditions);
            }
            $countResult = $conn->query($countSql);
            $totalRecords = $countResult->fetch_assoc()['total'];
            $totalPages = ceil($totalRecords / $itemsPerPage);

            // Add pagination to the main query
            $sql .= " ORDER BY `date` DESC LIMIT $itemsPerPage OFFSET $offset";

            $result = $conn->query($sql);
            if (!$result) {
                echo "<p><strong>Query error:</strong> " . $conn->error . "</p>";
            } elseif ($result->num_rows == 0) {
                echo '<div class="no-data">
                    <i class="fas fa-inbox"></i>
                    <p>No SMS data found matching your criteria.</p>
                </div>';
            } else {
                echo '<div class="table-container">';
                echo '<table>';
                echo '<thead>
                    <tr>
                        <th>A/C</th>
                        <th>Amount</th>
                        <th>Debit</th>
                        <th>Credit</th>
                        <th>Balance</th>
                        <th>Sender</th>
                        <th>Transaction ID</th>
                        <th>Date & Time</th>
                        <th>Cheque No</th>
                    </tr>
                </thead>
                <tbody>';
                while ($row = $result->fetch_assoc()) {
                    $parsed = parse_sms_body($row['body']);
                    $dateTime = date('d-m-Y H:i:s', intval($row['date'] / 1000));
                    echo '<tr>';
                    echo '<td>'.htmlspecialchars($parsed['A/C']).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['Amount']).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['Debit']).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['Credit']).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['Balance']).'</td>';
                    echo '<td>'.htmlspecialchars($row['address']).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['Transaction ID']).'</td>';
                    echo '<td>'.htmlspecialchars($dateTime).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['Cheque No']).'</td>';
                    echo '</tr>';
                }
                echo '</tbody></table></div>';
                
                // Pagination controls
                if ($totalPages > 1) {
                    echo '<div class="pagination">';
                    if ($currentPage > 1) {
                        $params = $_GET;
                        $params['page'] = $currentPage - 1;
                        echo '<a href="?' . http_build_query($params) . '"><i class="fas fa-chevron-left"></i> Previous</a>';
                    }
                    
                    // Show page numbers
                    $startPage = max(1, $currentPage - 2);
                    $endPage = min($totalPages, $currentPage + 2);
                    
                    if ($startPage > 1) {
                        $params = $_GET;
                        $params['page'] = 1;
                        echo '<a href="?' . http_build_query($params) . '">1</a>';
                        if ($startPage > 2) {
                            echo '<span>...</span>';
                        }
                    }
                    
                    for ($i = $startPage; $i <= $endPage; $i++) {
                        if ($i == $currentPage) {
                            echo '<span class="current-page">' . $i . '</span>';
                        } else {
                            $params = $_GET;
                            $params['page'] = $i;
                            echo '<a href="?' . http_build_query($params) . '">' . $i . '</a>';
                        }
                    }
                    
                    if ($endPage < $totalPages) {
                        if ($endPage < $totalPages - 1) {
                            echo '<span>...</span>';
                        }
                        $params = $_GET;
                        $params['page'] = $totalPages;
                        echo '<a href="?' . http_build_query($params) . '">' . $totalPages . '</a>';
                    }
                    
                    if ($currentPage < $totalPages) {
                        $params = $_GET;
                        $params['page'] = $currentPage + 1;
                        echo '<a href="?' . http_build_query($params) . '">Next <i class="fas fa-chevron-right"></i></a>';
                    }
                    echo '</div>';
                    
                    // Pagination info
                    echo '<div class="pagination-info">';
                    echo 'Showing ' . (($currentPage - 1) * $itemsPerPage + 1) . ' to ' . min($currentPage * $itemsPerPage, $totalRecords) . ' of ' . $totalRecords . ' entries';
                    echo '</div>';
                }
            }
            endif;
            ?>
        </div>
        
        <!-- Blocked Numbers Tab Content -->
        <div class="tab-content" id="blocked-numbers-content">
            <div class="blocked-numbers-section">
                <div class="blocked-numbers-header">
                    <div class="blocked-numbers-title"><i class="fas fa-ban"></i> Manage Blocked Numbers</div>
                </div>
                
                <form method="post" class="add-blocked-form">
                    <div class="form-group">
                        <label for="phone_name">Phone Name (Optional)</label>
                        <input type="text" id="phone_name" name="phone_name" placeholder="e.g., Bank Name">
                    </div>
                    
                    <div class="form-group">
                        <label for="blocked_number">Blocked Number *</label>
                        <input type="text" id="blocked_number" name="blocked_number" placeholder="e.g., +8801234567890" required>
                    </div>
                    
                    <div>
                        <button type="submit" name="add_blocked_number" class="btn btn-primary">
                            <i class="fas fa-plus"></i> Add Blocked Number
                        </button>
                    </div>
                </form>
                
                <div class="blocked-numbers-list">
                    <h3>Current Blocked Numbers</h3>
                    
                    <?php if (empty($blockedNumbers)): ?>
                        <div class="no-data">
                            <i class="fas fa-check-circle"></i>
                            <p>No blocked numbers found.</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($blockedNumbers as $blocked): ?>
                            <div class="blocked-number-item">
                                <div class="blocked-number-info">
                                    <div class="blocked-number-icon">
                                        <i class="fas fa-ban"></i>
                                    </div>
                                    <div class="blocked-number-details">
                                        <h4><?= htmlspecialchars($blocked['phone_name'] ?: 'Unknown') ?></h4>
                                        <p><?= htmlspecialchars($blocked['blocked_number']) ?> • Added on <?= date('d-m-Y H:i', strtotime($blocked['created_at'])) ?></p>
                                    </div>
                                </div>
                                <a href="?delete_blocked=<?= $blocked['id'] ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to unblock this number?')">
                                    <i class="fas fa-trash"></i> Unblock
                                </a>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Tab functionality
        document.getElementById('transactions-tab').addEventListener('click', function() {
            showTab('transactions');
        });
        
        document.getElementById('blocked-numbers-tab').addEventListener('click', function() {
            showTab('blocked-numbers');
        });
        
        function showTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.tab').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Show selected tab content
            document.getElementById(tabName + '-content').classList.add('active');
            
            // Add active class to selected tab
            document.getElementById(tabName + '-tab').classList.add('active');
        }
        
        // Modal functionality
        function showModal(title, message) {
            document.getElementById('modalTitle').textContent = title;
            document.getElementById('modalMessage').textContent = message;
            document.getElementById('messageModal').style.display = 'block';
        }
        
        function closeModal() {
            document.getElementById('messageModal').style.display = 'none';
        }
        
        // Show messages in modal if they exist
        <?php if (!empty($successMessage)): ?>
            showModal('Success', '<?= htmlspecialchars($successMessage) ?>');
        <?php endif; ?>
        
        <?php if (!empty($errorMessage)): ?>
            showModal('Error', '<?= htmlspecialchars($errorMessage) ?>');
        <?php endif; ?>
        
        // Toggle filter section on mobile
        document.getElementById('filterToggle').addEventListener('click', function() {
            const filterContainer = document.getElementById('filterContainer');
            filterContainer.classList.toggle('active');
            
            const icon = this.querySelector('i');
            if (filterContainer.classList.contains('active')) {
                icon.classList.remove('fa-chevron-down');
                icon.classList.add('fa-chevron-up');
            } else {
                icon.classList.remove('fa-chevron-up');
                icon.classList.add('fa-chevron-down');
            }
        });

        // Reset filters
        document.getElementById('resetBtn').addEventListener('click', function() {
            // Keep the selected table but reset all filters
            const urlParams = new URLSearchParams(window.location.search);
            const table = urlParams.get('table');
            window.location.href = '?table=' + encodeURIComponent(table);
        });

        // Auto-submit form when table selection changes
        document.getElementById('table').addEventListener('change', function() {
            document.getElementById('filterForm').submit();
        });
        
        // Close modal when clicking outside of it
        window.onclick = function(event) {
            const modal = document.getElementById('messageModal');
            if (event.target == modal) {
                closeModal();
            }
        }
    </script>
</body>
</html>