<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database configuration
$dbHost = 'localhost';
$dbUser = 'bdinfcom_SMS';
$dbPass = '!8OGQ!K+V!==';
$dbName = 'bdinfcom_SMS';

// Establish database connection
$conn = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
if ($conn->connect_error) {
    die("Database connection failed: " . $conn->connect_error);
}

// Get all blocked numbers
$blockedNumbers = [];
$res = $conn->query("SELECT blocked_number FROM blocked_numbers_global");
while ($row = $res->fetch_assoc()) {
    $blockedNumbers[] = $row['blocked_number'];
}

// Get all SMS tables
$tables = [];
$res = $conn->query("SHOW TABLES LIKE '%_sms'");
while ($row = $res->fetch_row()) {
    $tables[] = $row[0];
}

// Get selected table from URL or default to first table
$selectedTable = $_GET['table'] ?? '';
if ($selectedTable && !in_array($selectedTable, $tables)) {
    die("Invalid table selected.");
}

// Date filter inputs with default to current month
$currentMonthStart = date('Y-m-01');
$currentMonthEnd = date('Y-m-t');
$fromDateInput = $_GET['from_date'] ?? $currentMonthStart;
$toDateInput = $_GET['to_date'] ?? $currentMonthEnd;

$fromTimestamp = $toTimestamp = null;
if ($fromDateInput) $fromTimestamp = (int)(strtotime($fromDateInput . ' 00:00:00') * 1000);
if ($toDateInput)   $toTimestamp = (int)(strtotime($toDateInput . ' 23:59:59') * 1000);

// Pagination setup
$perPage = 50;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $perPage;

// Function to parse SMS body and extract transaction details
function parse_sms_body($body) {
    $result = [
        'A/C' => '', 'Amount' => '', 'Debit' => '', 'Credit' => '',
        'Balance' => '', 'Sender' => '', 'Transaction ID' => '', 'Cheque No' => '', 'From' => ''
    ];

    // Remove "Fee Tk 0.00" from the body
    $body = preg_replace('/Fee Tk 0\.00/i', '', $body);
    
    $text = preg_replace("/[\r\n]+/", " ", $body);
    $text = preg_replace('/\s+/', ' ', $text);

    // Account number extraction
    if (preg_match('/(?:A\/C|Account|Acc|A\/C#|A\/C:|Acc:)[\s\-]*([0-9*\-]{5,20})/i', $text, $m)) {
        $result['A/C'] = $m[1];
    }
    
    // Amount extraction
    if (preg_match('/(?:BDT|Tk|৳|TK\.?)\s*([\d,]+\.\d{2})/i', $text, $m)) {
        $result['Amount'] = str_replace(',', '', $m[1]);
    }
    
    // Debit extraction
    if (preg_match('/(?:withdrawn|debited|sent|paid|withdrawal|withdraw)[^0-9]*([\d,]+\.\d{2})/i', $text, $m)) {
        $result['Debit'] = str_replace(',', '', $m[1]);
        if (empty($result['Amount'])) $result['Amount'] = $result['Debit'];
    }
    
    // Credit extraction
    if (preg_match('/(?:deposited|credited|received|recharged)[^0-9]*([\d,]+\.\d{2})/i', $text, $m)) {
        $result['Credit'] = str_replace(',', '', $m[1]);
        if (empty($result['Amount'])) $result['Amount'] = $result['Credit'];
    }
    
    // Balance extraction
    if (preg_match('/(?:bal|balance|avl bal|available balance)[\s:]*[A-Za-z]*\s*([\d,]+\.\d{2})/i', $text, $m)) {
        $result['Balance'] = str_replace(',', '', $m[1]);
    }
    
    // Transaction ID extraction
    if (preg_match('/(?:trxid|transaction id|txn id|ref no|ref|reference|trx id)[\s:]*([A-Z0-9]{5,})/i', $text, $m)) {
        $result['Transaction ID'] = $m[1];
    }
    
    // Cheque number extraction
    if (preg_match('/(?:cheque no|chq no|cheque|chq)[\s:]*([A-Z0-9]{3,})/i', $text, $m)) {
        $result['Cheque No'] = $m[1];
    }

    // Extract Branch/From information
    if (preg_match('/(?:from|through|via)\s+([A-Za-z0-9 .\-]+?)(?=\s+(?:at|on|Bal|Balance|A\/C|Enjoy|$))/i', $text, $m)) {
        $result['From'] = trim($m[1]);
    } elseif (preg_match('/\b([A-Za-z .\-]+ Br\.?)\b/i', $text, $m)) {
        $result['From'] = trim(preg_replace('/Br\.?/i', '', $m[1]));
    } elseif (preg_match('/branch on\s+([0-9\-]+)\.?/i', $text, $m)) {
        $result['From'] = trim($m[1]);
    }

    return $result;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMS Transaction Viewer</title>
    <style>
        :root {
            --primary-color: #4285f4;
            --secondary-color: #f1f3f4;
            --hover-color: #e8f0fe;
            --border-color: #dadce0;
            --text-color: #202124;
            --light-text: #5f6368;
        }
        
        body {
            font-family: 'Roboto', Arial, sans-serif;
            color: var(--text-color);
            line-height: 1.6;
            padding: 20px;
            max-width: 1400px;
            margin: 0 auto;
            background-color: #f8f9fa;
        }
        
        h2 {
            color: var(--primary-color);
            margin-bottom: 20px;
            border-bottom: 1px solid var(--border-color);
            padding-bottom: 10px;
        }
        
        h3 {
            color: var(--primary-color);
            margin-top: 30px;
        }
        
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .filter-section {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            align-items: flex-end;
            margin-bottom: 20px;
        }
        
        .filter-group {
            display: flex;
            flex-direction: column;
        }
        
        label {
            font-weight: 500;
            margin-bottom: 5px;
            color: var(--light-text);
        }
        
        select, input[type=date] {
            padding: 10px 12px;
            border: 1px solid var(--border-color);
            border-radius: 4px;
            font-size: 14px;
            min-width: 200px;
        }
        
        select:focus, input[type=date]:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(66,133,244,0.2);
        }
        
        button {
            background-color: var(--primary-color);
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: background-color 0.2s;
            height: 40px;
        }
        
        button:hover {
            background-color: #3367d6;
        }
        
        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;
            box-shadow: 0 1px 2px rgba(0,0,0,0.1);
            background: white;
            border-radius: 8px;
            overflow: hidden;
        }
        
        th, td {
            border: 1px solid var(--border-color);
            padding: 12px 15px;
            text-align: left;
        }
        
        th {
            background-color: var(--secondary-color);
            font-weight: 500;
            color: var(--text-color);
            position: sticky;
            top: 0;
        }
        
        tr:nth-child(even) {
            background-color: #fafafa;
        }
        
        tr:hover {
            background-color: var(--hover-color);
        }
        
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 25px;
            flex-wrap: wrap;
        }
        
        .pagination a, .pagination strong {
            padding: 8px 16px;
            margin: 0 4px;
            border-radius: 4px;
            text-decoration: none;
            transition: background-color 0.3s;
        }
        
        .pagination a {
            color: var(--primary-color);
            border: 1px solid var(--border-color);
            background-color: white;
        }
        
        .pagination a:hover {
            background-color: var(--secondary-color);
        }
        
        .pagination strong {
            background-color: var(--primary-color);
            color: white;
            border: 1px solid var(--primary-color);
        }
        
        .summary {
            margin: 15px 0;
            padding: 10px;
            background-color: #e8f0fe;
            border-radius: 4px;
            color: var(--text-color);
        }
        
        .no-data {
            text-align: center;
            padding: 40px;
            color: var(--light-text);
            font-size: 16px;
        }
        
        @media (max-width: 768px) {
            .filter-section {
                flex-direction: column;
                align-items: stretch;
            }
            
            select, input[type=date] {
                width: 100%;
            }
            
            table {
                display: block;
                overflow-x: auto;
            }
        }
    </style>
</head>
<body>
    <div class="card">
        <h2>SMS Transaction Viewer</h2>
        
        <form method="get" class="filter-section">
            <div class="filter-group">
                <label for="table">Select Account</label>
                <select name="table" id="table" required onchange="this.form.submit()">
                    <option value="">-- Select Account --</option>
                    <?php foreach ($tables as $table): 
                        $displayName = str_replace('_sms', '', $table);
                        $displayName = ucwords(str_replace('_', ' ', $displayName));
                    ?>
                        <option value="<?=htmlspecialchars($table)?>" <?= ($table === $selectedTable) ? 'selected' : '' ?>>
                            <?=htmlspecialchars($displayName)?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="filter-group">
                <label for="from_date">From Date</label>
                <input type="date" name="from_date" id="from_date" value="<?=htmlspecialchars($fromDateInput)?>">
            </div>
            
            <div class="filter-group">
                <label for="to_date">To Date</label>
                <input type="date" name="to_date" id="to_date" value="<?=htmlspecialchars($toDateInput)?>">
            </div>
            
            <button type="submit">Apply Filters</button>
        </form>
    </div>

    <?php if ($selectedTable): ?>
        <div class="card">
            <?php
            $displayTableName = str_replace('_sms', '', $selectedTable);
            $displayTableName = ucwords(str_replace('_', ' ', $displayTableName));
            ?>
            <h3><?=htmlspecialchars($displayTableName)?> Transactions</h3>
            
            <?php
            $conditions = [];
            if ($fromTimestamp !== null) $conditions[] = "date >= $fromTimestamp";
            if ($toTimestamp !== null) $conditions[] = "date <= $toTimestamp";
            
            // Add condition to exclude blocked numbers
            if (!empty($blockedNumbers)) {
                $blockedList = "'" . implode("','", array_map([$conn, 'real_escape_string'], $blockedNumbers)) . "'";
                $conditions[] = "address NOT IN ($blockedList)";
            }

            // Count total rows for pagination
            $countSql = "SELECT COUNT(*) as total FROM $selectedTable";
            if ($conditions) {
                $countSql .= " WHERE " . implode(' AND ', $conditions);
            }
            $countResult = $conn->query($countSql);
            $totalRows = $countResult->fetch_assoc()['total'];
            $totalPages = ceil($totalRows / $perPage);

            // Calculate date range for summary
            $dateRangeSql = "SELECT MIN(date) as min_date, MAX(date) as max_date FROM $selectedTable";
            if ($conditions) {
                $dateRangeSql .= " WHERE " . implode(' AND ', $conditions);
            }
            $dateRangeResult = $conn->query($dateRangeSql);
            $dateRange = $dateRangeResult->fetch_assoc();
            $minDate = $dateRange['min_date'] ? date('d M Y', (int)($dateRange['min_date']/1000)) : 'N/A';
            $maxDate = $dateRange['max_date'] ? date('d M Y', (int)($dateRange['max_date']/1000)) : 'N/A';

            // Main query
            $sql = "SELECT * FROM $selectedTable";
            if ($conditions) {
                $sql .= " WHERE " . implode(' AND ', $conditions);
            }
            $sql .= " ORDER BY date DESC LIMIT $perPage OFFSET $offset";

            $result = $conn->query($sql);

            if (!$result) {
                echo "<div class='no-data'>Query error: " . $conn->error . "</div>";
            } elseif ($result->num_rows == 0) {
                echo "<div class='no-data'>No transactions found for the selected date range.</div>";
            } else {
                // Display summary information
                echo "<div class='summary'>";
                echo "Showing " . number_format($totalRows) . " transactions";
                if ($fromDateInput || $toDateInput) {
                    echo " between " . date('d M Y', strtotime($fromDateInput)) . " and " . date('d M Y', strtotime($toDateInput));
                }
                echo ". Full date range available: $minDate to $maxDate";
                echo "</div>";
                
                echo '<table>';
                echo '<thead><tr>
                    <th>A/C No</th>
                    <th>Amount</th>
                    <th>Debit</th>
                    <th>Credit</th>
                    <th>Balance</th>
                    <th>Sender</th>
                    <th>Transaction ID</th>
                    <th>Date & Time</th>
                    <th>Cheque No</th>
                    <th>From</th>
                </tr></thead><tbody>';

                while ($row = $result->fetch_assoc()) {
                    $parsed = parse_sms_body($row['body']);
                    $dateTime = date('d M Y H:i:s', (int)($row['date'] / 1000));

                    echo '<tr>';
                    echo '<td>'.htmlspecialchars($parsed['A/C']).'</td>';
                    echo '<td>'.($parsed['Amount'] ? htmlspecialchars(number_format($parsed['Amount'], 2)) : '').'</td>';
                    echo '<td>'.($parsed['Debit'] ? htmlspecialchars(number_format($parsed['Debit'], 2)) : '').'</td>';
                    echo '<td>'.($parsed['Credit'] ? htmlspecialchars(number_format($parsed['Credit'], 2)) : '').'</td>';
                    echo '<td>'.($parsed['Balance'] ? htmlspecialchars(number_format($parsed['Balance'], 2)) : '').'</td>';
                    echo '<td>'.htmlspecialchars($row['address']).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['Transaction ID']).'</td>';
                    echo '<td>'.htmlspecialchars($dateTime).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['Cheque No']).'</td>';
                    echo '<td>'.htmlspecialchars($parsed['From']).'</td>';
                    echo '</tr>';
                }
                echo '</tbody></table>';

                // Pagination links
                if ($totalPages > 1) {
                    echo '<div class="pagination">';
                    
                    // Previous page link
                    if ($page > 1) {
                        $query = $_GET;
                        $query['page'] = $page - 1;
                        $queryString = http_build_query($query);
                        echo "<a href='?$queryString'>&laquo; Previous</a>";
                    }
                    
                    // Page numbers
                    $startPage = max(1, $page - 2);
                    $endPage = min($totalPages, $page + 2);
                    
                    if ($startPage > 1) {
                        $query = $_GET;
                        $query['page'] = 1;
                        $queryString = http_build_query($query);
                        echo "<a href='?$queryString'>1</a>";
                        if ($startPage > 2) echo "<span>...</span>";
                    }
                    
                    for ($i = $startPage; $i <= $endPage; $i++) {
                        $query = $_GET;
                        $query['page'] = $i;
                        $queryString = http_build_query($query);
                        $isCurrent = ($i == $page);
                        echo $isCurrent
                            ? "<strong>$i</strong>"
                            : "<a href='?$queryString'>$i</a>";
                    }
                    
                    if ($endPage < $totalPages) {
                        if ($endPage < $totalPages - 1) echo "<span>...</span>";
                        $query = $_GET;
                        $query['page'] = $totalPages;
                        $queryString = http_build_query($query);
                        echo "<a href='?$queryString'>$totalPages</a>";
                    }
                    
                    // Next page link
                    if ($page < $totalPages) {
                        $query = $_GET;
                        $query['page'] = $page + 1;
                        $queryString = http_build_query($query);
                        echo "<a href='?$queryString'>Next &raquo;</a>";
                    }
                    
                    echo '</div>';
                }
            }
            ?>
        </div>
    <?php else: ?>
        <div class="card no-data">
            Please select an account to view transactions
        </div>
    <?php endif; ?>

    <script>
        // Set default date range to current month if not set
        document.addEventListener('DOMContentLoaded', function() {
            const fromDate = document.getElementById('from_date');
            const toDate = document.getElementById('to_date');
            
            if (fromDate && !fromDate.value) {
                fromDate.value = '<?= $currentMonthStart ?>';
            }
            
            if (toDate && !toDate.value) {
                toDate.value = '<?= $currentMonthEnd ?>';
            }
        });
    </script>
</body>
</html>
<?php $conn->close(); ?>