package com.example.sms_call_sync;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;

public class AutoSyncReceiver extends BroadcastReceiver {
    private static final String TAG = "AutoSyncReceiver";
    
    @Override
    public void onReceive(Context context, Intent intent) {
        Log.d(TAG, "Received broadcast: " + intent.getAction());
        
        if (Intent.ACTION_BOOT_COMPLETED.equals(intent.getAction()) ||
            "android.intent.action.QUICKBOOT_POWERON".equals(intent.getAction())) {
            
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(context);
            boolean autoSyncEnabled = prefs.getBoolean("auto_sync_enabled", false);
            String serverUrl = prefs.getString("server_url", "");
            String phoneName = prefs.getString("phone_name", "");

            Log.d(TAG, "Auto sync enabled: " + autoSyncEnabled);
            Log.d(TAG, "Server URL configured: " + !serverUrl.isEmpty());
            Log.d(TAG, "Phone name configured: " + !phoneName.isEmpty());

            if (autoSyncEnabled && !serverUrl.isEmpty() && !phoneName.isEmpty()) {
                Log.d(TAG, "Starting AutoSyncService");
                Intent serviceIntent = new Intent(context, AutoSyncService.class);
                context.startForegroundService(serviceIntent);
            }
        }
    }
}
